/*
 * Copyright (c) 1999-2001 Lutris Technologies, Inc. All Rights
 * Reserved.
 * 
 * This source code file is distributed by Lutris Technologies, Inc. for
 * use only by licensed users of product(s) that include this source
 * file. Use of this source file or the software that uses it is covered
 * by the terms and conditions of the Lutris Enhydra Development License
 * Agreement included with this product.
 * 
 * This Software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF
 * ANY KIND, either express or implied. See the License for the specific terms
 * governing rights and limitations under the License.
 * 
 * Contributor(s):
 * 
 * $Id: WapExtensionEvent.java,v 1.1.1.1 2001/01/05 05:11:17 sese0235 Exp $
 */

package de.kxml.wap;

import de.kxml.*;
import de.kxml.parser.*;

/**
 * Class declaration
 *
 *
 * @author
 * @version %I%, %G%
 */
public class WapExtensionEvent extends ParseEvent {
    int    id;
    Object content;

    /**
     * Constructor declaration
     *
     *
     * @param id
     * @param content
     *
     * @see
     */
    public WapExtensionEvent(int id, Object content) {
	this.id = id;
	this.content = content;
    }

    /**
     * Method declaration
     *
     *
     * @param start
     *
     * @return
     *
     * @see
     */
    public boolean endCheck(StartTag start) {
	return false;
    } 

    /**
     * returns Xml.WAP_EXTENSION
     */
    public int getType() {
	return Xml.WAP_EXTENSION;
    } 

    /**
     * returns the id of the WAP extendsion, one of Wbxml.EXT_0,
     * Wbxml.EXT_1, Wbxml.EXT_2, Wbxml.EXT_T_0, Wbxml.EXT_T_1,
     * Wbxml.EXT_T_2, Wbxml.EXT_I_0, Wbxml.EXT_I_1, Wbxml.EXT_I_2, or
     * Wbxml.OPAQUE.
     */
    public int getId() {
	return id;
    } 

    /**
     * returns the content of the wap extension. The class
     * depends on the type of the extension. null for EXT_0..EXT_2,
     * String for EXT_I_0..EXT_I_2, Integer for EXT_T_0..EXT_T_2,
     * byte [] for OPAQUE.
     */
    public Object getContent() {
	return content;
    } 

}

